implementation module receiverdefaccess


import	StdTuple
import	StdReceiverDef, commondef


receiverDefAttributes :: !(Receiver m .ls .ps) -> (RId m,SelectState,[Id],ReceiverFunction m *(.ls,.ps))
receiverDefAttributes (Receiver rid f atts)
	= (rid, getSelectState atts, getConnected atts, f)

receiver2DefAttributes :: !(Receiver2 m r .ls .ps) -> (R2Id m r, SelectState, [Id], Receiver2Function m r *(.ls,.ps))
receiver2DefAttributes (Receiver2 r2id f atts)
	= (r2id,getSelectState atts, getConnected atts, f)

getSelectState :: ![ReceiverAttribute .ps] -> SelectState
getSelectState atts
	= getreceiverselectstate selectAtt
where
	(_,selectAtt)	= Select isreceiverselectstate defSelect atts
	defSelect		= ReceiverSelectState Able

getConnected :: ![ReceiverAttribute .ps] -> [Id]
getConnected atts
=	case connectedAtt of
		(ReceiverConnectedReceivers idList)	-> idList
where
	(_,connectedAtt)	= Select isConnectedAttr defConnected atts
	defConnected		= ReceiverConnectedReceivers []
	isConnectedAttr (ReceiverConnectedReceivers _)	= True
	isConnectedAttr _									= False

receiverDefSetAbility :: !SelectState !(Receiver m .ls .ps) -> Receiver m .ls .ps
receiverDefSetAbility ability (Receiver rid f atts)
	= Receiver rid f (setSelectState ability atts)

receiver2DefSetAbility :: !SelectState !(Receiver2 m r .ls .ps) -> Receiver2 m r .ls .ps
receiver2DefSetAbility ability (Receiver2 r2id f atts)
	= Receiver2 r2id f (setSelectState ability atts)

setSelectState :: !SelectState ![ReceiverAttribute .ps] -> [ReceiverAttribute .ps]
setSelectState ability atts
	= snd (Replace isreceiverselectstate att atts)
where
	att	= ReceiverSelectState ability


receiverDefSetFunction :: !(ReceiverFunction m *(.ls,.ps)) !(Receiver m .ls .ps) -> Receiver m .ls .ps
receiverDefSetFunction f (Receiver rid _ atts)
	= Receiver rid f atts

receiver2DefSetFunction :: !(Receiver2Function m r *(.ls,.ps)) !(Receiver2 m r .ls .ps) -> Receiver2 m r .ls .ps
receiver2DefSetFunction f (Receiver2 r2id _ atts)
	= Receiver2 r2id f atts


isreceiverselectstate :: !(ReceiverAttribute .ps) -> Bool
isreceiverselectstate (ReceiverSelectState _)	= True
isreceiverselectstate _							= False

getreceiverselectstate :: !(ReceiverAttribute .ps) -> SelectState
getreceiverselectstate (ReceiverSelectState s)	= s
